<?php

namespace App\Traits;

use Mtc\MercuryDataModels\GlobalContent;

trait RetrievesGlobalContentForEmailFooter
{
    public function getFooterFromGlobalContent(string $slug)
    {
        $footerText = '';
        $globalContent = GlobalContent::query()->where('slug', $slug)->first();

        if (is_null($globalContent)) {
            return null;
        }

        foreach ($globalContent?->content as $content) {
            if (!empty($content['children'])) {
                foreach ($content['children'] as $childContent) {
                    if ($childContent['slug'] == 'footer') {
                        $footerText = $childContent['content'];
                    }
                }
            }
        }

        return $footerText;
    }
}
