<?php

namespace App\Traits;

use App\Facades\TaxonomyMapper;

trait MapsTaxonomies
{
    /**
     * @return string
     */
    abstract protected function getProviderName(): string;

    /**
     * Get the array of details to be saved.
     * Can be overridden to define the array to be saved.
     *
     * @param array|null $record
     * @return array
     */
    protected function getDetailsForTaxonomyMap(?array $record): array
    {
        return [];
    }

    /**
     * @param string $taxonomy
     * @param $value
     * @param array|null $vehicle_data
     * @param ?int $make_id
     * @return mixed
     */
    private function getMappedTaxonomy(
        string $taxonomy,
        $value,
        array $vehicle_data = null,
        ?int $make_id = null
    ): mixed {
        return TaxonomyMapper::getMappedTaxonomy(
            $this->getProviderName(),
            $taxonomy,
            $value,
            $this->getDetailsForTaxonomyMap($vehicle_data),
            $make_id
        );
    }

    public function storeUnmappedTaxonomy($vehicle): void
    {
        TaxonomyMapper::storeUnmappedTaxonomies($vehicle);
    }
}
