<?php

namespace App\Traits;

use App\VehicleType;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;

trait MakeAndModelList
{
    private function getMakeList(?string $type = null): Collection
    {
        $column = $this->getMakeTypeColumn($type);

        return VehicleMake::query()
            ->with('filterIndex')
            ->select('name', 'id')
            ->when($column, fn($query) => $query->where($column, 1))
            ->orderBy('name')
            ->get();
    }

    private function getModelList(?int $makeId, ?string $type = null): Collection
    {
        return $makeId
            ? VehicleModel::query()
                ->with('filterIndex')
                ->select('name', 'id')
                ->ofMake($makeId)
                ->when($type, fn($query) => $query->where('type', $type))
                ->orderBy('name')
                ->get()
            : collect();
    }

    private function getMakeTypeColumn(?string $type): ?string
    {
        return match ($type) {
            VehicleType::CAR->value => 'cars',
            VehicleType::LCV->value => 'lcvs',
            VehicleType::MOTORCYCLE->value => 'motorcycles',
            default => null,
        };
    }
}
