<?php

namespace App\Traits;

use App\Tier;
use App\TierHelper;
use Mtc\MercuryDataModels\Franchise;

trait FranchiseData
{
    private function hasFranchises(): bool
    {
        return TierHelper::isAllowed(tenant('tier'), Tier::PRO->value);
    }

    private function franchiseFilter(): array
    {
        return [
            'type' => 'list',
            'name' => __('labels.franchise'),
            'values' => Franchise::query()
                ->select('name', 'slug')
                ->get()
                ->map(fn(Franchise $franchise) => [
                    'id' => $franchise->slug,
                    'value' => 'franchise-' . $franchise->slug,
                    'name' => $franchise->name,
                ]),
        ];
    }
}
