<?php

namespace App\Traits;

trait FormatAsCurrency
{
    public function asCurrency(float $value, ?string $currency = null, int $decimals = 0): string
    {
        $formatter = (new \NumberFormatter('en-GB', \NumberFormatter::CURRENCY));
        $formatter->setAttribute(\NumberFormatter::MAX_FRACTION_DIGITS, $decimals);
        return $formatter->formatCurrency($value, $currency ?? config('app.currency'));
    }
}
