<?php

declare(strict_types=1);

namespace App;

use Illuminate\Support\Str;
use Stancl\Tenancy\Contracts\UniqueIdentifierGenerator;

class TenantUUIDGenerator implements UniqueIdentifierGenerator
{
    public static function generate($resource): string
    {
        return Str::slug($resource->name, '_') . '_' . Str::random(6);
    }
}
