<?php

namespace App;

use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;

trait SavesVehicleSpecTypeData
{
    private function syncSpecs(Vehicle|VehicleOffer $vehicle, Collection $specs): void
    {
        $vehicle->specs()
            ->whereNotIn('id', $specs->filter(fn ($spec) => is_numeric($spec['id']))->pluck('id'))
            ->delete();

        $specs->reject(fn ($spec) => is_numeric($spec['id']))
            ->each(fn ($spec) => $vehicle->specs()->create($spec));
    }


    private function syncFeatures(Vehicle|VehicleOffer $vehicle, Collection $features): void
    {
        $vehicle->features()
            ->whereNotIn('id', $features->filter(fn ($feature) => is_numeric($feature['id']))->pluck('id'))
            ->delete();

        $features->reject(fn ($feature) => is_numeric($feature['id']))
            ->each(fn ($feature) => $vehicle->features()->create($feature));
    }


    private function syncEquipment(Vehicle|VehicleOffer $vehicle, Collection $equipment): void
    {
        $vehicle->equipment()
            ->whereNotIn('id', $equipment->filter(fn ($entry) => is_numeric($entry['id']))->pluck('id'))
            ->delete();

        $equipment->reject(fn ($entry) => is_numeric($entry['id']))
            ->each(fn ($entry) => $vehicle->equipment()->create($entry));
    }
}
