<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class SupportedDashboardWidgetRule implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if (!in_array($value, $this->availableWidgets())) {
            $fail('Unsupported widget selected');
        }
    }

    private function availableWidgets(): array
    {
        return array_keys(config('dashboard.widgets', []));
    }
}
