<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class StringContainsStringRule implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct(private readonly ?string $mustContain)
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return stripos($value, $this->mustContain) !== false;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return "Incorrect string, must contain $this->mustContain as part of string.";
    }
}
