<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\ValidationRule;
use App\Facades\Country;

class CountryCodeExists implements ValidationRule
{
    /**
     * Validate the attribute.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @param  \Closure  $fail
     */
    public function validate(string $attribute, mixed $value, \Closure $fail): void
    {
        if (!Country::getAll()->pluck('code')->contains($value)) {
            $fail("The selected country code '{$value}' is invalid.");
        }
    }
}
