<?php

namespace App\Reporting;

use App\Contracts\ReportTile;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;
use Illuminate\Database\Eloquent\Relations\Relation;

class TaxonomyCountTile extends ReportTile
{
    private $value;

    public function __construct(private string $taxonomy)
    {
        /** @var Model model */
        $this->model = App::make(Relation::getMorphedModel($this->taxonomy));
    }

    public function name(): string
    {
        return __('taxonomies.' . $this->taxonomy);
    }

    public function value(): mixed
    {
        if (empty($this->value)) {
            $this->value = $this->model->newQuery()->count();
        }
        return $this->value;
    }

    public function difference(): mixed
    {
        return 0;
    }

    public function secondaryValue(): mixed
    {
        return 0;
    }

    public function subtitle(): string
    {
        return '';
    }

    public function differenceType(): string
    {
        if ($this->difference() > 0) {
            return 'positive';
        }
        return $this->difference() < 0
            ? 'negative'
            : 'noChange';
    }

    public function secondaryValueName(): string
    {
        return '';
    }
}
