<?php

namespace App\Reporting;

use App\Contracts\ReportTile;

class InventoryTurnoverRatioTile extends ReportTile
{
    public function name(): string
    {
        return 'Inventory turnover ratio';
    }

    public function value(): mixed
    {
        return 2426;
    }

    public function difference(): mixed
    {
        return '1%';
    }

    public function secondaryValue(): mixed
    {
        return 2421;
    }

    public function subtitle(): string
    {
        return 'last 30 days';
    }

    public function differenceType(): string
    {
        if ($this->difference() > 0) {
            return 'positive';
        }
        return $this->difference() < 0
            ? 'negative'
            : 'noChange';
    }

    public function secondaryValueName(): string
    {
        return 'prev 30 d.';
    }
}
