<?php

namespace App\ReportTypes;

use Illuminate\Database\Eloquent\Builder;
use Mtc\Crm\Models\FormQuestion;
use Mtc\MercuryDataModels\Enquiry;

class EnquiryReport
{
    /**
     * Report name
     *
     * @return string
     */
    public function name(): string
    {
        return 'Enquiries';
    }

    /**
     * Columns that can be used
     *
     * @return string[]
     */
    public function columns(): array
    {
        return array_merge([
            'type.name' => 'Type',
            'reason.name' => 'Related data',
            'valuation.retail_price' => 'Valuation',
            'title' => 'Name',
            'email' => 'Email',
            'created_at' => 'Submitted',
            'created_at_since' => 'Days since submitted',
        ], $this->getQuestionNames());
    }

    /**
     * Start a query
     *
     * @return Builder
     */
    public function query(): Builder
    {
        return Enquiry::query();
    }

    private function getQuestionNames()
    {
        return FormQuestion::query()
            ->whereHas('form')
            ->whereNotIn('type', ['message', 'submit_button', 'file_upload'])
            ->pluck('name')
            ->keyBy(fn($name) => 'value.' . $name)
            ->unique()
            ->toArray();
    }
}
