<?php

namespace App\Notifications;

use App\Facades\Settings;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Mtc\ContentManager\Contracts\VersionModel;
use Mtc\MercuryDataModels\Tools\UiUrlGenerator;
use Mtc\MercuryDataModels\User;

class PageVersionMarkedChangesRequested extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(private readonly VersionModel $version, private readonly User $user)
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param mixed $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $url = '/manage-content/content/edit/' . $this->version->page_id . '/version/' . $this->version->id;
        return (new MailMessage())
            ->subject("Changes Requested on {$this->version->page->title} page - " . Settings::get('app-name'))
            ->line("Your work version on page '{$this->version->page->title}' "
                . "has been marked as Changes Requested by " . $this->user->name)
            ->action('Review page version', UiUrlGenerator::make($url));
    }

    /**
     * Get the array representation of the notification.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
