<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Mtc\MercuryDataModels\Tenant;
use Mtc\MercuryDataModels\Tools\UiUrlGenerator;

class AddedToSiteNotification extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(private Tenant $site, private string $role, private $password = null)
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param mixed $notifiable
     * @return MailMessage
     */
    public function toMail($notifiable)
    {
        $url = app()->environment('local')
            ? '//localhost:8000/login?email=' . $notifiable->email
            : url('login?email=' . $notifiable->email);
        return (new MailMessage())
            ->subject('You have been invited to collaborate on ' . $this->site->name)
            ->line('You have been invited to collaborate on **' . $this->site->name . '** as ' . $this->role)
            ->when($this->password, function (MailMessage $message) use ($notifiable) {
                $message
                    ->line('Your login email: ' . $notifiable->email)
                    ->line('Your temporary password: ' . $this->password);
            })
            ->action('Log In', $url);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
