<?php

namespace App\Modules\VehicleTrims\Http\Resources;

use App\Master\Models\VehicleMake;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\VehicleModel;
use Mtc\MercuryDataModels\VehicleTrim;

class VehicleTrimList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->through(fn(VehicleTrim $trim) => [
            'title' => $trim->name,
            'link' => '/manage-content/vehicle-trims/edit/' . $trim->id,
            'id' => $trim->id,
            'metaItems' => [
                'make' => VehicleMake::query()
                        ->where('id', '=', $trim->make_id)
                        ->first()
                        ->name ?? '',
                'model' => VehicleModel::query()
                        ->where('id', '=', $trim->model_id)
                        ->first()
                        ->name ?? '',
            ]
        ]);

        $data = $this->resource->toArray();

        $data['view_columns'] = [
            [
                'id' => 'make',
                'name' => 'Make',
                'icon' => '',
            ],
            [
                'id' => 'model',
                'name' => 'Model',
                'icon' => '',
            ],
        ];

        $data['default_columns'] = [
            'make',
            'model',
        ];

        return $data;
    }
}
