<?php

namespace App\Modules\VehicleLabels\Http\Requests;

use App\Rules\NumericTypeHasNumericValue;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class UpdateLabelRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'data.rules' => [
                'sometimes',
                new NumericTypeHasNumericValue(),
            ],
        ];
    }
}
