<?php

namespace App\Modules\Valuation\Config;

use App\Facades\Settings;
use Mtc\VehicleValuation\Config\MotorCheckConfig;

class MotorCheck extends MotorCheckConfig
{
    public function enabled(): bool
    {
        return Settings::get('valuation-motor-check-enabled') ?? false;
    }

    public function clientId(): string
    {
        return Settings::get('valuation-motor-check-client_id');
    }

    public function clientSecret(): string
    {
        return Settings::get('valuation-motor-check-client_secret');
    }

    public function valuationDriver(): string
    {
        return Settings::get('valuation-motor-check-driver', 'auto-trader');
    }

    public function country(): string
    {
        return Settings::get('app-details-country');
    }
}
