<?php

namespace App\Modules\Stock;

use App\Contracts\StockProvider;
use App\Facades\Settings;
use App\Imports\DealerInternetImport;

class DealerInternet implements StockProvider
{
    public function enabled(): bool
    {
        return Settings::get('stock-dealer-internet-enabled', false) ?? false;
    }

    public function name(): string
    {
        return 'dealer-internet-import';
    }

    public function runScheduledImport(bool $fullSync = true): void
    {
        (new DealerInternetImport())->importVehicles();
    }
}
