<?php

namespace App\Modules\ServiceBooking\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\Booking;

class ListServiceBookings extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $this->resource->through(fn(Booking $booking) => $this->maBooking($booking));
        return parent::toArray($request);
    }

    private function maBooking(Booking $booking)
    {
        $booking->title = $booking->first_name . ' ' . $booking->last_name;
        $booking->description = collect([
            strtoupper($booking->registration_number),
            $booking->vehicle_data['make'] ?? null,
            $booking->vehicle_data['model'] ?? null,
        ])->filter()->implode(' ');

        $booking->metaItems = [
            'location' => $booking->location?->name,
            'time' => $booking->booking_time?->format('d/m/Y H:i'),
        ];
        return $booking;
    }
}
