<?php

namespace App\Modules\ServiceBooking\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Modules\ServiceBooking\BookingRepository;
use App\Modules\ServiceBooking\Http\Requests\BookingCalendarRequest;
use App\Modules\ServiceBooking\Http\Resources\ViewServiceCalendar;

class ServiceCalendarController extends Controller
{
    public function index(BookingCalendarRequest $request, BookingRepository $repository): ViewServiceCalendar
    {
        return (new ViewServiceCalendar($repository->getCalendar($request)))
            ->setMonth($repository->getPeriodValue(), $request->input('period', 'month'));
    }
}
