<?php

namespace App\Modules\SalesChannels;

use App\Contracts\SalesChannel;
use App\Facades\Settings;
use App\Jobs\EbayMotorsExportJob;
use App\Traits\ChecksForExportMap;
use Illuminate\Foundation\Bus\DispatchesJobs;

class EbayMotors implements SalesChannel
{
    use DispatchesJobs;
    use ChecksForExportMap;

    /**
     * Check if channel is enabled
     *
     * @return bool
     */
    public function enabled(): bool
    {
        return (bool)Settings::get('sales-channels-ebay-motors-enabled');
    }

    public function name(): string
    {
        return __('sales_channels.ebay_motors');
    }

    /**
     * Run a scheduled export
     *
     * @return void
     */
    public function runScheduledExport(): void
    {
        if (!$this->hasActiveExportMap()) {
            $this->dispatch(new EbayMotorsExportJob());
        }
    }

    /**
     * Fields to add to dealership management
     *
     * @return array[]
     */
    public function dealershipAdditionalDataFields()
    {
        return [
            'ebay-motors-dealer-id' => [
                'type' => 'text',
                'label' => 'Feed ID on Ebay Motors'
            ],
        ];
    }
}
