<?php

namespace App\Modules\SalesChannels;

use App\Contracts\SalesChannel;
use App\Facades\Settings;
use App\Jobs\AutoTraderFeedExportJob;
use Illuminate\Foundation\Bus\DispatchesJobs;

class AutoTrader implements SalesChannel
{
    use DispatchesJobs;

    /**
     * Check if channel is enabled
     *
     * @return bool
     */
    public function enabled(): bool
    {
        return (bool)Settings::get('sales-channels-auto-trader-enabled');
    }

    public function name(): string
    {
        return __('sales_channels.auto-trader');
    }

    /**
     * Run a scheduled export
     *
     * @return void
     */
    public function runScheduledExport(): void
    {
        if ($this->enabled()) {
            $this->dispatch(new AutoTraderFeedExportJob());
        }
    }
}
