<?php

namespace App\Modules\Leasing\Jobs;

use Mtc\MercuryDataModels\KeyloopLeaseOptionCategory;

class OptionCategoryImportJob extends BaseImportJob
{
    protected function importItem(array $item)
    {
        KeyloopLeaseOptionCategory::query()->updateOrCreate(
            [
                'option_code' => $item['option_code'],
            ],
            [
                'name' => $item['name'],
                'was_recently_synced' => true,
            ],
        );
    }
}
