<?php

namespace App\Modules\Leasing\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Mtc\MercuryDataModels\KeyloopLeaseVehicleVariant;
use Mtc\MercuryDataModels\Leasing\KeyloopLeaseFinanceService;

class GenerateFinanceJob implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    public function handle()
    {
        KeyloopLeaseVehicleVariant::query()
            ->where('price_ex_vat_ex_vrt', '>', 0)
            ->chunkById(100, fn ($variants) => $variants->each(function ($variant) {
                // generate finance, clearing any cached finance options
                (new KeyloopLeaseFinanceService())->getVariantFinance($variant, true, true);
                $variant->update([
                    'finance_recently_updated' => true,
                ]);
            }));
    }
}
