<?php

namespace App\Modules\Finance\Services;

use App\Contracts\AddsDealershipFields;
use App\Facades\Settings;

class IVendi implements AddsDealershipFields
{
    /**
     * Fields to add to dealership management
     *
     * @return array[]
     */
    public function dealershipAdditionalDataFields(): array
    {
        return $this->getDealershipAdditionalDataFields();
    }

    protected function getDealershipAdditionalDataFields(): array
    {
        return [
            'ivendi' => [
                'type' => 'text',
                'label' => 'Dealer ID within iVendi (for per-dealer finance checks)',
            ],
            'ivendi-dealer-key' => [
                'type' => 'text',
                'label' => 'Dealer specific iVendi key for performing finance lookups',
            ],
            'finance-risk-based-pricing' => [
                'type' => 'boolean',
                'label' => 'Allow risk based finance checks on vehicles from this dealership',
            ]
        ];
    }

    public function enabled(): bool
    {
        return Settings::get('finance-ivendi-enabled', false);
    }
}
