<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\MercuryDataModels\Tenant;
use Mtc\MercuryDataModels\User;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class GoLiveTask extends Model
{
    use HasFactory;
    use CentralConnection;

    protected $fillable = [
        'tenant_id',
        'task',
        'last_triggered_at',
        'completed_at',
        'failed_at',
        'completed_by',
        'details',
    ];

    protected $casts = [
        'last_triggered_at' => 'datetime',
        'completed_at' => 'datetime',
        'failed_at' => 'datetime',
        'details' => 'array',
    ];

    public function tenant(): BelongsTo
    {
        return $this->belongsTo(Tenant::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
