<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Factories\ExportMapTemplateFactory;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class ExportMapTemplate extends Model
{
    use CentralConnection;
    use HasFactory;

    protected $fillable = [
        'is_published',
        'title',
        'sales_channel',
        'columns',
        'headers',
        'mapping_rules'
    ];

    protected $casts = [
        'columns' => 'array',
        'headers' => 'array',
        'mapping_rules' => 'array',
        'is_published' => 'bool',
    ];

    protected static function newFactory()
    {
        return ExportMapTemplateFactory::new();
    }

    public function scopePublished(Builder $query)
    {
        $query->where('is_published', 1);
    }
}
