<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

/**
 * @property int $id
 * @property int $ev_data_id
 * @property string $attribute_key
 * @property string|null $attribute_value
 */
class EVDataAttribute extends Model
{
    use CentralConnection;
    use HasFactory;

    protected $table = 'ev_data_attributes';

    protected $fillable = [
        'ev_data_id',
        'attribute_key',
        'attribute_value',
    ];

    public function evData(): BelongsTo
    {
        return $this->belongsTo(EVData::class);
    }
}
