<?php

namespace App\Master\Models;

use Mtc\Crm\Traits\ModelSortAndFilter;
use Mtc\MercuryDataModels\Factories\FuelTypeFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Traits\EnsuresSlug;
use Mtc\MercuryDataModels\Traits\OrderByName;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class FuelType extends Model
{
    use CentralConnection;
    use HasFactory;
    use OrderByName;
    use ModelSortAndFilter;
    use EnsuresSlug;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'fuel_types';

    /**
     * Mass assign columns
     *
     * @var string[]
     */
    protected $fillable = [
        'name',
        'slug',
        'ev_data',
        'mpg_data',
        'autotrader_id',
    ];

    /**
     * Columns shown in JSON response by default
     *
     * @var string[]
     */
    protected $visible = [
        'id',
        'slug',
        'name',
        'ev_data',
        'mpg_data',
    ];

    protected static function boot()
    {
        parent::boot();

        self::saving(function (self $fuelType) {
            $fuelType->ensureSlug();
        });
    }

    /**
     * Model factory
     *
     * @return FuelTypeFactory
     */
    protected static function newFactory()
    {
        return FuelTypeFactory::new();
    }
}
