<?php

namespace App\Master\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EVDataView extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->resource->id,
            'ev_db_id' => $this->resource->ev_db_id,
            'vehicle_type' => $this->resource->vehicle_type,
            'make_id' => $this->resource->make_id,
            'model_id' => $this->resource->model_id,
            'variant' => $this->resource->variant,
            'date_from' => $this->resource->date_from,
            'date_to' => $this->resource->date_to,
            'make' => $this->resource->make ? [
                'id' => $this->resource->make->id,
                'name' => $this->resource->make->name,
            ] : null,
            'model' => $this->resource->model ? [
                'id' => $this->resource->model->id,
                'name' => $this->resource->model->name,
            ] : null,
            'attributes' => $this->resource->evDataAttributes->map(function ($attr) {
                return [
                    'key' => $attr->attribute_key,
                    'value' => $attr->attribute_value,
                ];
            }),
        ];
    }
}
