<?php

namespace App\Master\Http\Requests;

use App\Models\ContentSync;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ContentSyncRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->hasHeader('x-token')
            &&  $this->hasHeader('x-user')
            && ContentSync::query()->where('token', $this->header('x-token'))
                ->whereHas('user', fn($query) => $query->where('email', $this->header('x-user')))
                ->where('created_at', '>=', Carbon::now()->subMinutes(ContentSync::TTL))
                ->exists();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'environment' => [
//                'required_if:direction,down'
            ],
            'scope' => [
//                'required_if:direction,down'
            ],
            'selections' => [
//                'required_if:direction,down'
            ],
            'data' => [
                'array',
            ]
        ];
    }

    /**
     * @return ContentSync|Model
     */
    public function sync(): ContentSync
    {
        return ContentSync::query()->where('token', $this->header('x-token'))
            ->whereHas('user', fn($query) => $query->where('email', $this->header('x-user')))
            ->where('created_at', '>=', Carbon::now()->subMinutes(ContentSync::TTL))
            ->firstOrFail();
    }
}
