<?php

namespace App\Master\Http\Controllers;

use App\Http\Resources\InvoiceListResource;
use App\Http\Resources\InvoiceViewResource;
use Illuminate\Http\Request;
use Mtc\MercuryDataModels\Invoice;

class InvoiceController
{
    /**
     * List invoices on system for all tenants
     *
     * @param Request $request
     * @return InvoiceListResource
     */
    public function index(Request $request)
    {
        $invoices = Invoice::query()
            ->when($request->has('status'), fn($query) => $query->where('status', $request->input('status')))
            ->when($request->has('tenant_id'), fn ($query) => $query->where('tenant_id', $request->input('tenant_id')))
            ->latest()
            ->paginate();
        return new InvoiceListResource($invoices);
    }

    /**
     * Show details of an invoice
     *
     * @param Invoice $invoice
     * @return InvoiceViewResource
     */
    public function show(Invoice $invoice)
    {
        return new InvoiceViewResource($invoice);
    }
}
