<?php

namespace App\Master\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Master\Http\Resources\EVDataList;
use App\Master\Http\Resources\EVDataView;
use App\Models\EVData;
use Illuminate\Http\Request;

class EVDataController extends Controller
{
    /**
     * Display a listing of EV data with pagination and search.
     */
    public function index(Request $request)
    {
        $query = EVData::query()
            ->with(['make', 'model']);

        if ($request->filled('make')) {
            $query->whereHas('make', function ($q) use ($request) {
                $q->where('name', 'like', '%' . $request->input('make') . '%');
            });
        }

        if ($request->filled('model')) {
            $query->whereHas('model', function ($q) use ($request) {
                $q->where('name', 'like', '%' . $request->input('model') . '%');
            });
        }

        if ($request->filled('variant')) {
            $query->where('variant', 'like', '%' . $request->input('variant') . '%');
        }

        if ($request->filled('vehicle_type')) {
            $query->where('vehicle_type', $request->input('vehicle_type'));
        }

        $evData = $query->orderBy('id', 'desc')->paginate($request->input('per_page', 25));

        return new EVDataList($evData);
    }

    /**
     * Display the specified EV data with all attributes.
     */
    public function show(EVData $evDatum)
    {
        $evDatum->load(['make', 'model', 'evDataAttributes']);

        return new EVDataView($evDatum);
    }
}
