<?php

namespace App\Mail;

use App\Facades\Settings;
use App\Traits\GetsColourSettings;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Address;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Support\Collection;

class OrphanedTaxonomyRemovedMail extends Mailable
{
    /**
     * Create a new message instance.
     */
    public function __construct(
        private readonly Collection $orphaned_taxonomy_makes,
        private readonly Collection $orphaned_taxonomy_models,
        private readonly Collection $affected_tenant_records,
    ) {
        //
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            from: new Address(config('mail.from.address'), config('mail.from.name')),
            subject: 'Orphaned taxonomies removed report',
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.alerts.orphaned-taxonomy-report',
            with: [
                'colours' => $this->getColours(),
                'orphaned_taxonomy_makes' => $this->orphaned_taxonomy_makes,
                'orphaned_taxonomy_models' => $this->orphaned_taxonomy_models,
                'affected_tenant_records' => $this->affected_tenant_records,
            ],
        );
    }

    private function getColours(): array
    {
        return [
            'app-text-colour' => '#000000',
            'app-primary-colour' => '#3C576B',
        ];
    }
}
