<?php

namespace App\Mail;

use App\Facades\Settings;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Traits\GetsColourSettings;
use Illuminate\Support\Collection;

class FailedEnquiryReport extends Mailable
{
    use Queueable;
    use SerializesModels;
    use GetsColourSettings;

    /**
     * Create a new message instance.
     *
     * @param Collection $failures An array of failures to be included in the report.
     */
    public function __construct(private readonly Collection $failures)
    {
        //
    }

    /**
     * Build the message.
     *
     * @return \Illuminate\Mail\Mailable
     */
    public function build()
    {
        return $this->subject('Failed Enquiry Actions Report')
            ->view('emails.alerts.failed_enquiry_report')
            ->with([
                'site_name' => Settings::get('app-name'),
                'site_logo' => Settings::get('site-logo'),
                'site_logo_alternate' => Settings::get('site-alternate-logo'),
                'colours' => $this->getColourSettings(),
                'failures' => $this->failures,
            ]);
    }
}
