<?php

namespace App\Mail;

use App\Facades\Settings;
use App\Facades\Site;
use App\Traits\GetsColourSettings;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Address;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Mtc\Crm\Contracts\EnquiryModel;
use Mtc\MercuryDataModels\GlobalContent;

trait CheckThemeTemplateTrait
{
    private function getTemplateName(string $template): string
    {
        $theme = Settings::get('mail-customer-theme');
        if (empty($theme) || $theme === 'default') {
            return 'crm::emails.' . $template;
        }

        if (view()->exists("crm::emails.$theme.$template")) {
            return "crm::emails.$theme.$template";
        }

        return 'crm::emails.' . $template;
    }
}
