<?php

namespace App\Listeners;

use App\Events\NewVehicleImported;
use App\Facades\Settings;
use App\VehicleSpec\Jobs\VehicleCapIdLookup;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Mtc\MercuryDataModels\Vehicle;

class VehicleCapIdLookupOnNewVehicleImport
{
    use DispatchesJobs;

    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(NewVehicleImported $event): void
    {
        if ($this->shouldRun($event->vehicle)) {
            $this->dispatch(new VehicleCapIdLookup($event->vehicle));
        }
    }

    private function shouldRun(Vehicle $vehicle): bool
    {
        return empty($vehicle->cap_id) && Settings::get('vehicle-spec-providers-cap-enabled');
    }
}
