<?php

namespace App\Listeners;

use App\Facades\Settings;
use App\Jobs\SalesforceStockExportJob;
use Illuminate\Foundation\Bus\DispatchesJobs;

class TriggerSalesforceStockExport
{
    use DispatchesJobs;

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle($event)
    {
        if ($this->shouldRun()) {
            $this->dispatch(new SalesforceStockExportJob());
        }
    }

    protected function shouldRun()
    {
        return Settings::get('sales-force-stock-export-enabled');
    }
}
