<?php

namespace App\Listeners;

use App\Events\NewVehicleImported;
use App\Facades\Settings;

class SetAutoTraderConnectPublishFlag
{
    public function __construct()
    {
        //
    }

    public function handle(NewVehicleImported $event)
    {
        if (Settings::get('sales-channels-auto-trader-enabled') === false) {
            return;
        }

        if ($event->vehicle->autoTraderData()->exists() === false) {
            $event->vehicle->autoTraderData()->create([
                'publish_advert' => Settings::get('auto-trader-connect-publish-new-cars') || empty($vehicle->is_new),
                'publish_profile' => Settings::get('auto-trader-connect-publish-new-cars') || empty($vehicle->is_new),
            ]);
        }
    }
}
