<?php

namespace App\Listeners;

use App\Facades\Settings;
use App\Services\AutoTraderHub;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Mtc\MercuryDataModels\Events\SettingUpdated;

class CreateSiteOnAutoTraderHub implements ShouldQueue
{
    use InteractsWithQueue;

    public function __construct(private readonly AutoTraderHub $autoTraderHub)
    {
        //
    }

    public function handle(SettingUpdated $event)
    {
        if ($event->setting->config_key === 'auto-trader-hub-enabled' && $event->setting->value) {
            if (Settings::get('auto-trader-hub-token')) {
                return;
            }

            $this->autoTraderHub->createSite();
        }
    }
}
