<?php

namespace App\Listeners;

use App\Events\NewVehicleImported;
use App\Facades\Settings;
use App\Modules\ImageSync\AutoloadIt;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Mtc\MercuryDataModels\ApiNotification;

class AutoLoadItNotificationResetOnNewVehicle
{
    use DispatchesJobs;

    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(NewVehicleImported $event): void
    {
        if (Settings::get('image-sync-autoloadit-enabled')) {
            $notification = ApiNotification::query()
                ->where('provider', AutoloadIt::PROVIDER_NAME)
                ->where('reference', $event->vehicle->vrm_condensed)
                ->latest()
                ->first();

            $notification?->update([
                'processed' => null,
            ]);
        }
    }
}
