<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Mtc\Filter\Contracts\IsFilter;
use App\Filter\FilterIndex;

class UpdateFilterIndexForRecord implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    private Model $model;
    private IsFilter $filter;
    private string $filter_type;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(Model $model, IsFilter $filter, string $filter_type)
    {
        $this->onQueue('sync');
        $this->model = $model;
        $this->filter = $filter;
        $this->filter_type = $filter_type;
        //
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle(): void
    {
        if (tenancy()->initialized === false) {
            return;
        }
        FilterIndex::index($this->filter_type, $this->model, $this->filter);
    }
}
