<?php

namespace App\Jobs;

use App\Facades\Settings;
use App\Services\CarAndDrivingService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\App;

class CarAndDrivingImportJob implements ShouldQueue, ShouldBeUnique
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    public $timeout = 1800;

    public $retryAfter = 3600;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(private readonly bool $ignoreSchedule = false)
    {
        $this->onQueue('sync');
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $carAndDrivingService = App::make(CarAndDrivingService::class);
        if (
            $carAndDrivingService->isCarAndDrivingEnabled() === false
            || empty($userId = Settings::get('app-content-car-and-driving-user-id'))
        ) {
            return;
        }

        $carAndDrivingService->import($userId);
    }
}
