<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\FilterFeature;

class FilterFeatureList extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $this->resource->through(fn(FilterFeature $feature) => [
            'title' => $feature->name,
            'link' => '/manage-content/filter-features/edit/' . $feature->id,
            'id' => $feature->id,
            'metaItems' => [
                'terms' => $feature->terms,
            ]
        ]);

        return parent::toArray($request);
    }
}
