<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class AuditViewResource extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->resource->id,
            'event' => $this->resource->event,
            'created_at' => $this->resource->created_at->format('d/m/Y H:i'),
            'user' => [
                'name' => $this->resource->user?->name,
                'ip_address' => $this->resource->ip_address,
                'user_agent' => $this->resource->user_agent,
            ],
            'auditable_url' => $this->getUrl(),
            'auditable_id' => $this->resource->auditable_id,
            'auditable_type' => $this->resource->auditable_type,
            'auditable_name' => $this->resource->name,
            'old_values' => $this->resource->old_values,
            'new_values' => $this->resource->new_values,
        ];
    }

    private function getUrl(): string
    {
        return match ($this->resource->auditable_type) {
            'page' => '/manage-content/pages/edit/' . $this->resource->auditable_id,
            'offer' => '/manage-content/offers/edit/' . $this->resource->auditable_id,
            'vehicle' => '/manage-content/vehicles/edit/' . $this->resource->auditable_id,
            'franchise' => '/manage-content/franchises/edit/' . $this->resource->auditable_id,
            'dealership' => '/manage-content/dealerships/edit/' . $this->resource->auditable_id,
            'menu' => '/manage-content/menus/edit/' . $this->resource->auditable_id,
            'media' => '/manage-content/media/',
            'setting' => '/settings',
            'global' => '/manage-content/global/edit/' . $this->resource->auditable_id,
            'templates' => '/manage-content/templates/edit/' . $this->resource->auditable_id,
            default => '',
        };
    }
}
