<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use JetBrains\PhpStorm\ArrayShape;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class UpdateSiteUserRequest extends FormRequest
{
    use CentralConnection;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check() && Auth::user()->hasRole(['mtc', 'Administrator']);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    #[ArrayShape(['userId' => "string[]", 'role' => "string[]"])] public function rules()
    {
        $global = $this->getConnectionName();
        return [
            'userId' => [
                'required',
                "exists:$global.users,id"
            ],
            'role' => [
                'required',
                "exists:$global.roles,name"
            ]
        ];
    }
}
