<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Mtc\MercuryDataModels\SeoData;

class UpdateNewCarRequest extends FormRequest
{
    public $attributes = [
        'make_id' => 'vehicle make',
        'model_id' => 'vehicle model',
        'seo.title' => 'SEO page title',
        'seo.description' => 'SEO page description',
    ];

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'seo.title' => [
                'nullable',
                'min:' . SeoData::TITLE_MIN_LENGTH,
                'max:' . SeoData::TITLE_MAX_LENGTH,
            ],
            'seo.description' => [
                'nullable',
                'min:' . SeoData::DESCRIPTION_MIN_LENGTH,
                'max:' . SeoData::DESCRIPTION_MAX_LENGTH,
            ],
            'make_id' => [
                'required',
            ],
            'model_id' => [
                'required',
            ],
            'trims.*.name' => [
                'required'
            ],
            'price' => [
                'nullable',
                'numeric'
            ],
            'excerpt' => [
                'nullable',
                'max:255',
            ],
            'monthly_price' => [
                'nullable',
                'numeric'
            ],
            'engine_size_cc' => [
                'nullable',
                'numeric'
            ],
            'seo.jsonSchema' => 'json',
        ];
    }
}
