<?php

namespace App\Http\Requests;

use App\Rules\SupportedDashboardWidgetRule;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class SetDashboardWidgetsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'widgets' => 'array',
            'widgets.*' => 'array',
            'widgets.*.widget' => [
                'required',
                new SupportedDashboardWidgetRule()
            ],
            'widgets.*.data' => [
                'nullable',
                'array',
            ]
        ];
    }
}
