<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class ServiceAvailabilityRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'active' => [
                'present',
                'boolean',
            ],
            'email' => [
                'present',
            ],
            'number_of_bays' => [
                'required',
                'numeric'
            ],
            'time_windows' => [
                'array'
            ],
            'time_windows.*' => 'date_format:H:i',
            'mondays' => [
                'boolean',
            ],
            'tuesdays' => [
                'boolean',
            ],
            'wednesdays' => [
                'boolean',
            ],
            'thursdays' => [
                'boolean',
            ],
            'fridays' => [
                'boolean',
            ],
            'saturdays' => [
                'boolean',
            ],
            'sundays' => [
                'boolean',
            ],
            'min_days_in_future_for_booking' => [
                'numeric',
                'min:0',
            ],
            'max_days_in_future_for_booking' => [
                'numeric',
                'min:0',
            ],
            'holidays' => 'array',
            'holidays.*' => 'date_format:Y-m-d',
        ];
    }
}
